/*
  A single goal explosion when scoring. Spawned by UTBRGoalExplosion.
  Author Mark Caldwell aka W@rHe@d of The Reliquary
  
  Note: Can not have this class extend the ut explosion class because it's lifespan is very short so when it's destroyed
  server side that causes premature client side destroy and cuts off the visual effect to just a small short puff.
  So, this class spawns the ut explosion client side.
*/

class UTBRExplosion extends Actor;

simulated function PostBeginPlay()
{
    super.PostBeginPlay();
    
    spawn(class'UTEmit_VehicleHit');
    
    //playing sound from this class is cool because it makes the sound come from this particular explosion's location
    PlaySound(SoundCue'A_Weapon_RocketLauncher.Cue.A_Weapon_RL_Impact_Cue' , true);      
}

//must have a good long lifespan to make sure effect has time to replicate and play out client side
defaultproperties
{
   LifeSpan=10.0
   RemoteRole = ROLE_SimulatedProxy
   bAlwaysRelevant = true
   Name="Default__UTBRExplosion"
   ObjectArchetype=Actor'Engine.Default__Actor'
}
